# Strom růstu – To-Do List

Motivační to-do aplikace se symbolem stromu. Plň úkoly a sleduj, jak roste tvůj strom. Aplikace motivuje k růstu, sleduje sérii dní (streak) a funguje jako **PWA** – lze ji nainstalovat na telefon i počítač z tvého webu.

## Funkce

- **Úkoly** – přidávání, označení jako splněno, mazání
- **Strom růstu** – s každými 5 splněnými úkoly strom postoupí do další fáze (semeno → klíček → mladý strom → strom → rozkvetlý strom)
- **Statistiky** – počet splněných úkolů dnes, celkem a série dní v řadě (streak)
- **Motivační citáty** – krátké povzbuzení při plnění
- **Filtry** – zobrazení všech, jen aktivních nebo jen splněných úkolů
- **Offline** – díky Service Workeru funguje i bez připojení po prvním načtení
- **Instalace** – na mobilu (Android/iOS) nebo v prohlížeči na počítači lze aplikaci „Přidat na plochu“ / „Nainstalovat“

## Struktura projektu

```
to-do list/
├── index.html            # Hlavní stránka
├── stahnout-android.html # Stránka pro stažení APK pro Android
├── manifest.json         # PWA manifest (název, ikony, barvy)
├── sw.js                 # Service Worker (offline cache)
├── css/
│   └── style.css         # Styly
├── js/
│   └── app.js            # Logika úkolů, stromu, statistik
├── icons/
│   ├── icon-192.png      # Ikona 192×192 px (doporučeno přidat)
│   └── icon-512.png      # Ikona 512×512 px (doporučeno přidat)
├── Strom-rustu.apk       # (volitelně) Vygenerovaný APK – nahraj vedle index.html
└── README.md
```

## Nasazení na tvůj web

1. **Nahraj celou složku** (všechny soubory včetně `css/`, `js/`, `manifest.json`, `sw.js`) na svůj web tak, aby byl přístupný přes HTTPS.
2. **Kořen aplikace** – například `https://tvujweb.cz/strom-rustu/`. Pak musí být:
   - `https://tvujweb.cz/strom-rustu/index.html`
   - `https://tvujweb.cz/strom-rustu/manifest.json`
   - atd.
3. **Ikony (volitelné, ale doporučené)**  
   Pro hezkou instalaci PWA přidej do složky `icons/` obrázky:
   - `icon-192.png` – 192×192 px  
   - `icon-512.png` – 512×512 px  
   Můžeš je vygenerovat např. na [realfavicongenerator.net](https://realfavicongenerator.net/) nebo [pwa-asset-generator](https://www.npmjs.com/package/pwa-asset-generator) a nahradit placeholder v `icons/`.
4. **Start URL v manifestu**  
   Pokud aplikace nebude v kořeni webu, uprav v `manifest.json` položku `start_url`, např.:
   ```json
   "start_url": "./strom-rustu/index.html"
   ```

## Jak získat instalační soubor pro Android (APK)

Aby si uživatelé na Androidu mohli stáhnout jeden instalační soubor (APK) a nainstalovat aplikaci včetně ikony na ploše, postupuj takto:

1. **Nahrát aplikaci na web**  
   Nahraj celou složku projektu (včetně `index.html`, `manifest.json`, `sw.js`, `css/`, `js/`, `icons/`) na Netlify nebo GitHub Pages. Zapiš si URL aplikace (např. `https://strom-rustu.netlify.app`).

2. **Vygenerovat APK**  
   Otevři [pwabuilder.com](https://www.pwabuilder.com/), zadej URL aplikace a klikni na „Start“. Po analýze zvol **Android** a stáhni vygenerovaný balíček (APK).

3. **Kde APK nabídnout**  
   - **Varianta A:** Přejmenuj stažený soubor na `Strom-rustu.apk` a nahraj ho do **stejné složky** jako `index.html` na tom samém hostingu (Netlify/GitHub Pages). Stránka `stahnout-android.html` pak funguje s odkazem `./Strom-rustu.apk` a uživatelé mohou stahovat přímo z ní.  
   - **Varianta B:** Nahraj APK na Webnode jako soubor ke stažení (Vložit soubor), zkopíruj odkaz na soubor a v `stahnout-android.html` změň odkaz tlačítka „Stáhnout aplikaci (APK)“ na tuto URL.

4. **Odkaz na stránku stažení**  
   Na svém webu (Webnode nebo jinde) dej odkaz na `stahnout-android.html` (celá URL podle toho, kde aplikace běží). Uživatelé na Androidu tak mohou jedním kliknutím přejít na stažení, stáhnout APK, otevřít ho a nainstalovat – na ploše se vytvoří ikona.

## Instalace na zařízení

- **Telefon (Android):** V Chrome otevři stránku s aplikací → Menu (⋮) → „Přidat na plochu“ / „Nainstalovat aplikaci“. Nebo použij stránku [stahnout-android.html](stahnout-android.html) a stáhni APK.
- **Telefon (iOS):** V Safari → tlačítko Sdílet → „Přidat na plochu“.
- **Počítač (Chrome/Edge):** V adresním řádku se objeví ikona instalace nebo Menu → „Nainstalovat Strom růstu…“.

## Lokální spuštění

Stačí otevřít `index.html` v prohlížeči. Pro plnou funkci PWA (instalace, offline) je potřeba běžet přes HTTP(S) server, např.:

```bash
npx serve .
# nebo
python -m http.server 8000
```

Pak otevři v prohlížeči uvedenou adresu (např. `http://localhost:3000`).

## Technologie

- Čistý HTML, CSS a JavaScript (bez frameworku)
- Local Storage pro ukládání úkolů a statistik
- PWA (manifest + Service Worker) pro instalaci a offline režim

---

*Strom růstu – každý splněný úkol je kapka pro tvůj strom.*
